
# present-act-hinges-sr

A **self-contained** repository to run **hinge-calibrated** simulations under a
boolean/ordinal **present‑act** engine:

- **Step 0**: Engine preflight (RNG only at exact ties, no-skip guard).
- **Step 1**: **Time hinge** \(T^*\) via **reach threshold** → derive **c**.
- **Step 2**: **Spatial hinge** (UGM) via single **kink** with **two rails** (boolean corridors).
- **Step 3**: **Special Relativity** with hinges (or placeholders) using **boolean drift**.

No intensities, no curve weights, no resampling; **integer commit counts** only.

## Quickstart (CPU only)
```bash
python -m venv .venv && source .venv/bin/activate   # Windows: .venv\Scripts\activate
pip install -r requirements.txt

# Low-compute defaults
python scripts/step0_preflight.py --config configs/low_compute.yaml
python scripts/step1_tstar.py    --config configs/low_compute.yaml
python scripts/step2_ugm.py      --config configs/low_compute.yaml
python scripts/step3_sr.py       --config configs/low_compute.yaml

# Or run all in sequence (continues on failure, marks placeholders)
python scripts/run_all.py --config configs/low_compute.yaml
```

Artifacts are written under `out/` with CSVs, PNGs and `RESULTS_*.md` summaries.

## Configuration
Edit `configs/low_compute.yaml` (or copy to `my_run.yaml`) to change containers,
shots, seeds, thresholds, and enable/disable rails/drift.

## Tests
```bash
pytest -q
```

## Design constraints
- Neighbor-only enumeration (4-neighbors); **no-skip** lint.
- **Equality fit** on a finite alphabet (phase bins tied to Θ + discrete bits).
- Gates are **boolean/ordinal** (Θ, κ, structural, CRA). **ParentGate off**.
- **Accept** by ratio-lex on \((d_{out}, d_{in}, d_\times)\), then **fewest-acts**.
- **RNG only** at **exact ties** (primitive column-stochastic kernel; PF eigenvector; **Born-squared** sampling).
- **Commit-only** screen (integer counts); ROI in **native pixels**; **no** normalization/resampling.
- Diagnostics are **read-only**; measure-invariance; kernel primitivity; re-centering determinism.
